/*
 * Decompiled with CFR 0.152.
 */
package br.com.backmap.mapback.service;

import br.com.backmap.mapback.model.Jogo;
import br.com.backmap.mapback.model.Usuario;
import br.com.backmap.mapback.repository.JogoRepository;
import br.com.backmap.mapback.repository.UsuarioRepository;
import br.com.backmap.mapback.service.AsaasIntegrationService;
import br.com.backmap.mapback.service.EmailService;
import java.security.SecureRandom;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class UsuarioService {
    @Autowired
    private UsuarioRepository usuarioRepository;
    @Autowired
    private JogoRepository jogoRepository;
    @Autowired
    private AsaasIntegrationService asaasIntegrationService;
    @Autowired
    private EmailService emailService;

    public List<Usuario> listarUsuarios() {
        return this.usuarioRepository.findAll();
    }

    public Optional<Usuario> buscarUsuarioPorId(Long id) {
        return this.usuarioRepository.findById((Object)id);
    }

    public Usuario salvarUsuario(Usuario usuario) {
        return (Usuario)this.usuarioRepository.save((Object)usuario);
    }

    public void deletarUsuario(Long id) {
        this.usuarioRepository.deleteById((Object)id);
    }

    public boolean existeUsuario(Long id) {
        return this.usuarioRepository.existsById((Object)id);
    }

    public Usuario cadastrarUsuario(Usuario usuario) throws Exception {
        Usuario savedUser = (Usuario)this.usuarioRepository.save((Object)usuario);
        savedUser.setStatusPagamento("PAGO");
        savedUser = (Usuario)this.usuarioRepository.save((Object)savedUser);
        this.emailService.sendWelcomeEmail(savedUser.getEmail(), savedUser.getNome());
        return savedUser;
    }

    public Usuario atualizarEtapa(Long id, String novaEtapa) throws Exception {
        Optional usuarioOptional = this.usuarioRepository.findById((Object)id);
        if (usuarioOptional.isPresent()) {
            Usuario usuario = (Usuario)usuarioOptional.get();
            if ("pista7".equals(novaEtapa)) {
                boolean existeUsuarioNaPistaFinal = this.usuarioRepository.existsByEtapa("pistaFinal");
                if (!existeUsuarioNaPistaFinal) {
                    usuario.setEtapa("pistaFinal");
                    this.finalizarTodosJogos();
                } else {
                    usuario.setEtapa(novaEtapa);
                }
            } else {
                usuario.setEtapa(novaEtapa);
            }
            return (Usuario)this.usuarioRepository.save((Object)usuario);
        }
        throw new Exception("Usu\u00e1rio n\u00e3o encontrado");
    }

    public void finalizarTodosUsuarios() {
        List usuarios = this.usuarioRepository.findAll();
        for (Usuario usuario : usuarios) {
            usuario.setFim(true);
            this.usuarioRepository.save((Object)usuario);
        }
    }

    public void finalizarTodosJogos() {
        List jogos = this.jogoRepository.findAll();
        for (Jogo jogo : jogos) {
            jogo.setFimDeJogo(true);
            this.jogoRepository.save((Object)jogo);
        }
    }

    public void solicitarResetSenha(String email) throws Exception {
        Usuario usuario = (Usuario)this.usuarioRepository.findByEmail(email);
        if (usuario == null) {
            throw new Exception("E-mail n\u00e3o encontrado");
        }
        String resetCode = this.generateResetCode();
        usuario.setResetCode(Integer.parseInt(resetCode));
        this.usuarioRepository.save((Object)usuario);
        this.emailService.sendPasswordResetEmail(email, usuario.getNome(), resetCode);
    }

    private String generateResetCode() {
        SecureRandom random = new SecureRandom();
        int code = random.nextInt(900000) + 100000;
        return String.valueOf(code);
    }

    public boolean alterarSenha(String email, int resetCode, String novaSenha) throws Exception {
        Usuario usuario = (Usuario)this.usuarioRepository.findByEmail(email);
        if (usuario != null && usuario.getResetCode() == resetCode) {
            String encryptedPassword = new BCryptPasswordEncoder().encode((CharSequence)novaSenha);
            usuario.setSenha(encryptedPassword);
            usuario.setResetCode(0);
            this.usuarioRepository.save((Object)usuario);
            return true;
        }
        return false;
    }
}

